﻿using System;
using System.Globalization;
using System.Xml.Linq;

namespace Azyobuzi.Twikoto2.Models.Twitter
{
    public class User
    {
        public User() { }

        public User(XElement xml)
        {
            this.CreatedAt = DateTime.ParseExact(
                xml.Element("created_at").Value,
                "ddd MMM dd HH:mm:ss %zzzz yyyy",
                CultureInfo.InvariantCulture,
                DateTimeStyles.AssumeUniversal);
            this.Id = xml.Element("id").Value;
            this.ScreenName = xml.Element("screen_name").Value;
            this.Name = xml.Element("name").Value;
            this.Description = xml.Element("description").Value;
            this.Location = xml.Element("location").Value;
            this.FriendsCount = int.Parse(xml.Element("friends_count").Value);
            this.FollowersCount = int.Parse(xml.Element("followers_count").Value);
            this.StatusesCount = int.Parse(xml.Element("statuses_count").Value);
        }

        public DateTime CreatedAt { get; set; }
        public string Id { get; set; }
        public string ScreenName { get; set; }
        public string Name { get; set; }
        public string Description { get; set; }
        public string Location { get; set; }
        public int FriendsCount { get; set; }
        public int FollowersCount { get; set; }
        public int StatusesCount { get; set; }
    }
}
